#!/usr/bin/env bash

# Parameters
env_name="Hopper-v2"
seeds=(0 1 2 3 4)
steps_list=(2 4 8 16)
model_dir="models"
count=0

# Log file for job submissions
log_file="job_submission_log.txt"
> $log_file  # Clear the log file at the start

for seed in "${seeds[@]}"; do
  for steps in "${steps_list[@]}"; do
    model_path="${model_dir}/SAC_GRU_${env_name}_${seed}_True_${steps}_4_final"
    
    # Check if the model already exists
    if ! [ -f "$model_path" ]; then
      sbatch --job-name="train_${env_name}_${seed}_${steps}" train_hsp.sh $seed $env_name $steps
      echo "Submitted job for seed=$seed, steps=$steps" | tee -a $log_file
      count=$((count + 1))
    else
      echo "Model already exists: $model_path. Skipping job submission for seed=$seed, steps=$steps." | tee -a $log_file
    fi
  done
done

echo "Launched $count jobs."
